const CommunicationService = isNavigatorWebdriver => {
    let connection = {};

    if (isNavigatorWebdriver) {
        connection = new WebSocket('ws://127.0.0.1:10000/gutenberg');

        connection.onopen = () => {
            console.log(`${new Date(Date.now()).toISOString()} -> [CONNECTION] Connection open. Extension id: ${chrome.runtime.id}`);
        };

        connection.onclose = () => {
            console.log(`${new Date(Date.now()).toISOString()} -> [CONNECTION] Connection closed`);
        };

        connection.onerror = () => {
            console.log(`${new Date(Date.now()).toISOString()} -> [CONNECTION] Connection error`);
        };

        connection.onmessage = (event) => {
            let data = JSON.parse(event.data);
            if (data[1].hasOwnProperty('type') && data[1].hasOwnProperty('data')) {
                const wrappedEvent = data[1];
                const {type} = wrappedEvent;
                const messageData = wrappedEvent.data ? wrappedEvent.data[1] : {};

                switch (type) {
                    case CONSTANTS.EVENTS.LOCAL_PLAYER.EVENT_GUTENBERG_CONNECTION_RESPONSE:
                        console.debug(`${new Date(Date.now()).toISOString()} -> [CONNECTION] Received message: ${JSON.stringify(data)}`);
                        EventsService.notify(CONSTANTS.EVENTS.LOCAL_PLAYER.EVENT_GUTENBERG_CONNECTION_RESPONSE, messageData);
                        break;
                    default:
                        break;
                }
            } else {
                console.log(`${new Date(Date.now()).toISOString()} -> [CONNECTION] Unknown message format: ${JSON.stringify(data)}`);
            }
        };
    }

    const _sendConnectionRequest = () => {
        if (!isNavigatorWebdriver) {
            return;
        }

        let version = chrome.runtime.getManifest().version;
        let message = [
            'com.subject7.proof.client.dto.executor.websocket.command.gutenberg.GutenbergConnectionRequestCommand',
            {
                type: 'COMMAND_GUTENBERG_CONNECTION_REQUEST',
                data: [
                    'com.subject7.proof.client.dto.executor.websocket.data.GutenbergConnectionRequestData',
                    {
                        version
                    }
                ]
            }
        ];

        console.debug(`${new Date(Date.now()).toISOString()} -> [CONNECTION] Sending message (COMMAND_GUTENBERG_CONNECTION_REQUEST)`);
        connection.send(JSON.stringify(message));
    };

    CommunicationService.sendConnectionRequest = _sendConnectionRequest;
};
